import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

plt.rcParams['font.sans-serif'] = ['SimHei']

#准备初始数据
df = pd.read_csv(r'D:/code/data/销售额.csv', index_col = 0, encoding = 'gbk')   #导入文件
x = df.index   #x轴数据
y = df['家用电器'].values   #y轴数据

fig = plt.figure(figsize = [10,5])

#添加子图，用于绘制折线图
fig.add_subplot(1,2,1)

#绘制图形
df['家用电器'].plot()   #默认将数据的index作为x轴数据，values 作为y轴数据
#df['家用电器'].plot.line()
#设置图形元素
plt.title('家用电器各季度销售额')  #设置标题
plt.ylabel('销售额（万元）')  #设置y轴标题

#添加子图，用于绘制箱形图
fig.add_subplot(1,2,2)

#绘制图形
df['家用电器'].plot.box()



plt.savefig(r'd:\code\data\折线图.png')

plt.show()
