#例10.9
import pandas as pd
import matplotlib.pyplot as plt

plt.rcParams['font.sans-serif'] = ['SimHei']

#准备数据
df = pd.read_csv(r'd:/code/data/销售额.csv', index_col = 0, encoding = 'gbk')
data = df.sum(axis = 0)

#创建空白画布
plt.figure()

labels = data.index  #准备标签数据
explode = [0, 0, 0.05]  #设置每块扇形的分离距离

#绘制图形
plt.pie(data, explode = explode, labels = labels, autopct = '%0.0f%%')

#设置标题
plt.title('各类产品总销售额比例图', fontdict={'fontsize':16, 'color':'red'})
plt.show()
