#例9.13
import pandas as pd

pd.set_option('display.unicode.east_asian_width', True)  #解决数据输出时列名不对称的问题

data = [
    [90, 85, 77],
    [88, 89, 78],
    [70, 65, 82],
    [87, 80, 90]
]
row = ['张三', '李四', '王五', '赵六']
col = ['数据库', '数据结构', 'Python数据分析']
df = pd.DataFrame(data, index = row, columns = col)

print('所有同学的成绩信息：\n', df)
print('-' * 50)

print('删除列标签为“Python数据分析”的列：\n', df.drop(labels = 'Python数据分析', axis = 1))
print('-' * 50)

print('删除“张三”和“王五”两位同学的成绩：\n', df.drop(['张三', '王五']))
print('-' * 50)

print('删除行标签为“张三”的行及列标签为“数据库”的列：\n', df.drop(index = '张三',columns='数据库'))
