#例9.27
import pandas as pd

df = pd.read_excel(r'D:/code/data/电脑外设销售表_new.xlsx')  #导入数据集

df1 = df.groupby('销售店').agg({'销售额':'sum'})  #分组字段作为分组结果的索引
print('分组统计的结果：')
print(df1, '\n', '-'*70)

df1 = df1.reset_index()   #重置索引
print('重置索引后的结果：')
print(df1, '\n', '-'*70)

df1.columns = ['销售店', '总销售额']  #修改列标签名
print('修改列标签名后的结果：')
print(df1, '\n', '-'*70)

df1['排名'] = df1['总销售额'].rank(ascending = False).astype('int')   #排名，并将“排名”列的数据类型改为整型
print('排名后的结果：')
print(df1)
